from cse_image_items.BaseItem import BaseItem
from cse_image_items.DataItem import DataItem
import json
import logging


logger = logging.getLogger(__name__)
MANIFEST_HEADER_JSON = 'layout/manifest_header.json'

try:
    with open(MANIFEST_HEADER_JSON) as manifest_header_json:
        manifest_header = json.load(manifest_header_json)
except IOError:
    logger.info('manifest header layout file does not exist')
    raise IOError('manifest header layout file does not exist')

class ManifestHeader(BaseItem):
    def __init__(self, data, **kwargs):
        logger.info('START ManifestHeader.__init__ FUNCTION')
        
        super(ManifestHeader, self).__init__(data, **manifest_header)
        self.version = DataItem(self.value, **manifest_header['version'])